/*"Gear Indicator": Simple OutGauge client for LFS
 * Author: Vladimir Kadlec
 *         vladimirkadlec@gmail.com
 *         http://www.fi.muni.cz/~xkadlec
 * Updated by:  Nick Aronson 29/05/07
 *              nick (dot) a (dot) aronson (at) gmail (dot) com
 * New feature: 5 LED rev meter outputs added
 */
/*
This file is part of Gear Indicator.

Gear Indicator is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Gear Indicator is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Gear Indicator; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __CONFIG_H__
#define __CONFIG_H__

#include "outsim.h"
#define NUMBER_OF_GEARS 10
typedef enum {PIN_1, PIN_9, PIN_14, PIN_16, PIN_17} PINS;
typedef enum {F_LOW_FUEL, F_SHIFT_LIGHT, F_TRACTION_CONTROL, F_SIGNAL_LIGHTS,
        F_HANDBRAKE, F_RPM_LIMITER, F_REDLINE, F_RPM1, F_RPM2, F_RPM3, F_RPM4, F_RPM5, F_NONE} LFS_FUNCS;

typedef struct {
    char debug;
    char *ip;
    int port;
    int lpt_base;
    int fuel_warning;
    unsigned char display[NUMBER_OF_GEARS];
    unsigned char shift_light;
    unsigned char disp_off;
    int blink_time;
    LFS_FUNCS pin_func[5];   // sizeof (PINS)
    unsigned char pin_func_neg[5];  // sizeof (PINS)
    word pin_lfs_flag[5];  // sizeof (PINS)
    int lpt_base_offset[5];
    unsigned char ext_off;
} Config;
void print_config (Config *conf);
void init_config (Config *conf);
int read_config (char *file_name, Config *conf);

#endif
